import React from "react";
import { View, Text } from "react-native";
import styles from "./ReviewsProgessbarStyles";
import Porgressbar from "../../../Porgressbar/Porgressbar";

const ReviewsProgessbar = ({ progessBarRating }) => {
	return (
		<View style={styles.progressWrap}>
			{progessBarRating?.map((p, id) => (
				<View key={id} style={styles.bodyContent}>
					<Text style={styles.count}>{(p?.rating).toFixed(1)}</Text>
					<View style={styles.progressbar}>
						<Porgressbar progress={p?.total_rating} height={6} />
					</View>
				</View>
			))}
		</View>
	);
};

export default ReviewsProgessbar;
